# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: gcc-c++ libGL-devel libcurl-devel libsqlite3-devel openmpi-devel python3-devel rpm-build-python3 unzip
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define piname statusbar_pi

Name:		opencpn-statusbar-plugin
Summary:	Plugin for OpenCPN implementing a more configurable statusbar
Version:	1.1.9.0
Release:	alt1_1
License:	GPLv3+
Group:		Sciences/Geosciences
URL:		https://opencpn.org/OpenCPN/plugins/statusbar.html
Source0:	https://github.com/rgleason/%{piname}/archive/v%{version}/%{piname}-%{version}.tar.gz
#download https://github.com/OpenCPN/opencpn-libs/archive/7ca85b14b54fb6bbad240923f665c996664c00c0.zip
Source1:    opencpn-libs-7ca85b14b54fb6bbad240923f665c996664c00c0.zip
Patch0:     opencpn-libs-7ca85b14-json.patch
Patch1:     opencpn-libs-7ca85b14-tinyxml.patch


BuildRequires:	ccmake cmake ctest
BuildRequires:	bzip2-devel
BuildRequires:	gettext gettext-tools
BuildRequires:	libwxBase3.2-devel libwxGTK3.2-devel
BuildRequires:	pkgconfig(gl)
BuildRequires:	pkgconfig(glu)
BuildRequires:	pkgconfig(zlib)
BuildRequires:	pkgconfig(tinyxml)
BuildRequires:  pkgconfig(jsoncpp)

Requires:	opencpn
Provides:	%{piname} = %{version}
Source44: import.info

%description
The OpenCPN built-in status bar has very limited configuration options
and can be difficult to read.

This plugin replaces it with a more configurable one.

For best results, the built-in toolbar on the User Interface
tab in the Toolbox should be disabled and the Y position of the plugin toolbar
set to at least the pixel size of the font selected in the plugin preferences.

%prep
%setup -q -a1 -n %{piname}-%{version}
%patch0 -p1
%patch1 -p1

mv opencpn-libs-7ca85b14b54fb6bbad240923f665c996664c00c0/{.,}* opencpn-libs/

%build
%{mageia_cmake}

%mageia_cmake_build

%install
%mageia_cmake_install

%find_lang opencpn-%{piname}

%ifarch x86_64 aarch64
mkdir -p %{buildroot}%{_libdir}/opencpn
mv %{buildroot}/usr/lib/opencpn/* %{buildroot}%{_libdir}/opencpn/
%endif

%files -f opencpn-%{piname}.lang
%{_libdir}/opencpn/lib%{piname}.so
%{_datadir}/opencpn/plugins/%{piname}/data/


%changelog
