# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
BuildRequires: gcc-c++ python3-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name openctm
%define major        1
%define libname      lib%{name}%{major}
%define libnamedev   lib%{name}-devel

Name:           openctm
Epoch:          0
Version:        1.0.3
Release:        alt1_24
Summary:        Library for compression of 3D triangle meshes
License:        zlib
Group:          System/Libraries
URL:            https://openctm.sourceforge.net/
Source0:        https://sourceforge.net/projects/openctm/files/OpenCTM-%{version}/OpenCTM-%{version}-src.tar.bz2
Patch0:         makefiles.patch
BuildRequires:  libjpeg-devel
BuildRequires:  pkgconfig(glew)
BuildRequires:  pkgconfig(freeglut)
BuildRequires:  pkgconfig(zlib)
BuildRequires:  pkgconfig(gtk+-2.0)
BuildRequires:  libpnglite-devel
BuildRequires:  pkgconfig(tinyxml)
BuildRequires:  pkgconfig(python3)
BuildRequires:  dos2unix
BuildRequires:  librply-devel
Source44: import.info

%description
OpenCTM a.. the Open Compressed Triangle Mesh file format a.. is a file format, 
a software library and a tool set for compression of 3D triangle meshes. 
The geometry is compressed to a fraction of comparable file formats, 
and the format is easily accessible through a simple, portable API. 

%package -n %{libname}
Summary:        Shared libraries for %{name}
Group:          System/Libraries
Provides:	lib%{name} = %{epoch}:%{version}-%{release}

%description -n %{libname}
OpenCTM a.. the Open Compressed Triangle Mesh file format a.. is a file format, 
a software library and a tool set for compression of 3D triangle meshes. 
The geometry is compressed to a fraction of comparable file formats, 
and the format is easily accessible through a simple, portable API.

This package contains the OpenCTM runtime library.

%package -n %{libnamedev}
Summary:        Header files and libraries for development with %{name}
Group:          Development/C
Requires:       %{libname} = %{epoch}:%{version}-%{release}
Provides:       %{name}-devel = %{epoch}:%{version}-%{release}
Provides:       lib%{name}-devel = %{epoch}:%{version}-%{release}

%description -n %{libnamedev}
Header files and libraries for development with %{name}.

%package -n python3-module-openctm
Summary:        Python 3 bindings for %{name}
Group:          Development/Python
BuildArch:      noarch
Requires:       lib%{name} = %{epoch}:%{version}-%{release}
%{?python_provide:%python_provide python3-%{name}}

%description -n python3-module-openctm
OpenCTM a.. the Open Compressed Triangle Mesh file format a.. is a file format, 
a software library and a tool set for compression of 3D triangle meshes. 
The geometry is compressed to a fraction of comparable file formats, 
and the format is easily accessible through a simple, portable API.

This package contains Python 3 binding for OpenCTM library.

%package doc
Summary:        Documentation for %{name} library and tools
Group:          System/Libraries
BuildArch:      noarch

%description doc
OpenCTM a.. the Open Compressed Triangle Mesh file format a.. is a file format, 
a software library and a tool set for compression of 3D triangle meshes. 
The geometry is compressed to a fraction of comparable file formats, 
and the format is easily accessible through a simple, portable API.

This package contains %{name} documentation.

%prep
%setup -q -n OpenCTM-%{version}
rm -f doc/DevelopersManual.pdf
rm -f doc/FormatSpecification.pdf
rm -rf tools/glew
rm -rf tools/jpeg
rm -rf tools/pnglite
rm -rf tools/tinyxml
rm -rf tools/zlib
dos2unix lib/Makefile.linux
%patch0 -p1

ln -s -f Makefile.linux Makefile

%build
export CFLAGS="%{optflags}"
export CXXFLAGS="%{optflags}"
%make_build LIBDIR=%{_libdir}/

%install
%makeinstall_std LIBDIR=%{_libdir}/

mkdir -p %{buildroot}%{python3_sitelibdir_noarch}
install -m 644 bindings/python/openctm.py %{buildroot}%{python3_sitelibdir_noarch}/openctm.py

%files
%doc README.txt
%{_bindir}/ctmconv
%{_bindir}/ctmviewer
%{_mandir}/man*/*

%files -n %{libname}
%{_libdir}/*.so.%{major}
%{_libdir}/*.so.%{major}.*

%files -n %{libnamedev}
%{_libdir}/*.so
%{_includedir}/*

%files -n python3-module-openctm
%doc bindings/python/ctminfo.py README.txt
%{python3_sitelibdir_noarch}/*

%files doc
%doc doc/APIReference/* README.txt



%changelog
