# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++ unzip zlib-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           osmose
Version:        0.9.98
Release:        alt1_9
Summary:        A Sega Master System/Game Gear emulator
Group:          Emulators
License:        GPLv3+ and LGPLv3+
URL:            http://bcz.asterope.fr
Source0:        https://github.com/lutris/osmose/archive/%{version}/%{name}-%{version}.tar.gz

BuildRequires:  pkgconfig(alsa)
BuildRequires:  pkgconfig(minizip)
BuildRequires:  pkgconfig(Qt5Core)
BuildRequires:  pkgconfig(Qt5Gui)
BuildRequires:  pkgconfig(Qt5OpenGL)
Source44: import.info

%description
Osmose is a Sega Master System/Game Gear console emulator.

It features:
- Qt-based GUI.
- OpenGL-based renderer.
- SMS emulation: Good compatibility. At this stage, the emulator can run 96%
  of commercial games and public demos, except games that relies on codemaster
  mapper, which works but does not have proper video mode emulated.
- Game Gear emulation: Good compatibility. At this stage, the emulator can
  run 98.0% of game gear ROMs.

%prep
%setup -q


# Make sure we don't use bundled minizip
rm -rf unzip

%build
%qmake_qt5 CONFIG+=system-minizip PREFIX=%{_prefix}
%make_build

%install
%makeinstall_std INSTALL_ROOT=%{buildroot}

%files
%doc LICENSE CREDITS README
%{_datadir}/applications/%{name}.desktop
%{_gamesbindir}/%{name}
%{_iconsdir}/hicolor/128x128/apps/%{name}.png


%changelog
