# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/db2html /usr/bin/gtkdoc-mkdb gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name ots
%define api_version     1
%define lib_major       0
%define lib_name        lib%{name}%{api_version}_%{lib_major}
%define develname 	libots-devel

Name:		ots
Summary:	A text summarizer
Version:	0.5.0
Release:	alt1_17
License:	GPLv2+
Group:		System/Libraries
URL:		http://libots.sourceforge.net/
Source:		%{name}-%{version}.tar.gz
Patch0:		ots-0.5.0-fix-underlinking.patch
Patch1:		ots-0.5.0-fix-installation.patch
Patch2:		ots-0.5.0-automake-1.13.patch
Patch3:		ots-0.5.0-fix-build.patch
BuildRequires:	glib2-devel
BuildRequires:	pkgconfig(libxml-2.0)
BuildRequires:	pkgconfig(popt)
Source44: import.info

%description
The open text summarizer is an open source tool for summarizing texts.
The program reads a text and decides which sentences are important and
which are not.
The program can either print the summarized text in text format or in
HTML form where the important sentences are highlighted in red.

The program is multi lingual and work with UTF-8 code;  At the moment
only English Hebrew are supported.

The ots command line tool is an example and a debug tool for the libary.
You can bind to the library from your program.

%package -n %{lib_name}
Summary:	Libraries for ots
Group:		System/Libraries
Requires:	%{name} >= %{version}-%{release}
Obsoletes:	libots-1_0

%description -n %{lib_name}
This package provides the libraries for using ots.


%package -n %{develname}
Summary:	Libraries and include files for developing with libots
Group:		Development/C
Requires:	%{lib_name} = %{version}-%{release}
Provides:	%{name}-devel = %{version}-%{release}
Obsoletes:	libots-1_0-devel

%description -n %{develname}
This package provides the necessary development libraries and include
files to allow you to develop with libots.


%prep
%setup -q -n ots-%{version}
%patch0 -p0
%patch1 -p0
%patch2 -p1 -b .automake-1_13
%patch3 -p1 -b .build-fix

%build
touch gtk-doc.make
autoreconf -fi
%configure --disable-gtk-doc --disable-static
%make_build -j1

%install
%makeinstall_std

# clean out unused files
rm -rf %{buildroot}%{_datadir}/doc/libots/html/*
rm -f %{buildroot}%{_libdir}/*.la

%files
%doc AUTHORS COPYING ChangeLog NEWS README TODO
%dir %{_datadir}/ots
%{_datadir}/ots/*
%{_bindir}/%{name}

%files -n %{lib_name}
%{_libdir}/*ots-1.so.%{lib_major}
%{_libdir}/*ots-1.so.%{lib_major}.*

%files -n %{develname}
%{_libdir}/*ots-1.so
%dir %{_includedir}/libots-1
%dir %{_includedir}/libots-1/ots
%{_includedir}/libots-1/ots/*.h
%{_libdir}/pkgconfig/libots-1.pc


%changelog
