Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-cmake rpm-macros-fedora-compat
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		packmol
Version:	20.14.2
Release:	alt1_4
Summary:	Packing optimization for molecular dynamics simulations
License:	MIT
URL:		http://m3g.iqm.unicamp.br/packmol/home.shtml
Source0:	https://github.com/mcubeg/packmol/archive/v%{version}/packmol-%{version}.tar.gz
# Example files
Source2:        http://leandro.iqm.unicamp.br/m3g/packmol/examples/examples.tar.gz

BuildRequires:	ctest cmake
BuildRequires:	gcc-fortran
Source44: import.info

%description
Packmol creates an initial point for molecular dynamics simulations by
packing molecules in defined regions of space. The packing guarantees
that short range repulsive interactions do not disrupt the
simulations.

The great variety of types of spatial constraints that can be
attributed to the molecules, or atoms within the molecules, makes it
easy to create ordered systems, such as lamellar, spherical or tubular
lipid layers.

The user must provide only the coordinates of one molecule of each
type, the number of molecules of each type and the spatial constraints
that each type of molecule must satisfy.

The package is compatible with input files of PDB, TINKER, XYZ and
MOLDY formats.


%prep
%setup -q
find . -name \*.o -delete
tar zxvf %{SOURCE2}

%build
export FC=gfortran
%{fedora_v2_cmake}
%fedora_v2_cmake_build

%install
%fedora_v2_cmake_install
install -D -p -m 755 solvate.tcl %{buildroot}%{_bindir}/packmol_solvate

%check
cd examples
for f in interface.inp; do
    out=$(basename $f .inp).out
    ../redhat-linux-build/packmol < $f | tee  $out
    ok=$(grep "Success" $out|wc -l)
    if(( ! $ok )); then
	echo "Example failed to run"
	exit
    fi
done

%files
%doc AUTHORS
%doc --no-dereference LICENSE
%{_bindir}/packmol
%{_bindir}/packmol_solvate

%changelog
