Group: Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define _default_patch_fuzz 2
Name: pads
Version: 1.2
Release: alt2_37
Summary: Passive Asset Detection System
License: GPL-2.0-or-later 
URL: http://passive.sourceforge.net/
Source0: http://prdownloads.sourceforge.net/passive/%{name}-%{version}.tar.gz
Source1: pads.service
Source2: pads.sysconfig
Patch1: pads-1.2-cleanup.patch
Patch2: pads-1.2-memleak.patch
Patch3: pads-1.2-overrun.patch
Patch4: pads-1.2-disable-debug.patch
Patch5: pads-1.2-daemonize.patch
Patch6: pads-1.2-ether-codes-update.patch
Patch7: pads-1.2-misc.patch
Patch8: pads-1.2-arp.patch
Patch9: pads-1.2-prelude.patch
Patch10: pads+vlan.patch
Patch11: pads-1.2-prelude-cleanup.patch
Patch12: pads-1.2-readonly.patch
Patch13: pads-1.2-bstring.patch
Patch14: pads-1.2-leak.patch
Patch15: pads-1.2-perf.patch
Patch16: pads-1.2-daemon.patch
Patch17: pads-1.2-pthreads.patch
Patch18: pads-aarch64.patch
Patch19: pads-1.2-inline-cleanup.patch
Patch20: pads-1.2-extra-libs.patch
BuildRequires:  gcc
BuildRequires: automake autoconf
BuildRequires: libpcre-devel libpcrecpp-devel libpcap-devel
BuildRequires: rpm-build-perl
BuildRequires: libsystemd-devel libudev-devel systemd systemd-analyze systemd-homed systemd-networkd systemd-portable systemd-sysvinit
Source44: import.info


%description
PADS is a libpcap based detection engine used to passively 
detect network assets.

%prep
%setup -q
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1
%patch16 -p1
%patch17 -p1
%patch18 -p1
%patch19 -p1
%patch20 -p1

%build
autoreconf -fv --install
%configure 
%make_build

%install
mkdir -p %{buildroot}%{_unitdir}
mkdir -p %{buildroot}%{_sysconfdir}/sysconfig
make install DESTDIR=%{buildroot}
install -m 644 %SOURCE1 %{buildroot}%{_unitdir}/pads.service
install -m 640 %SOURCE2 %{buildroot}%{_sysconfdir}/sysconfig/%{name}
# Remove installed docs since we pick this up another way
rm -rf $RPM_BUILD_ROOT/usr/share/pads/

%post
%post_service auditd

%preun
%preun_service auditd

%files
%doc doc/AUTHORS doc/COPYING doc/README doc/ChangeLog
%{_sysconfdir}/pads-ether-codes
%{_sysconfdir}/pads-signature-list
%config(noreplace) %attr(0640,root,root) %{_sysconfdir}/pads.conf
%config(noreplace) %attr(0640,root,root) %{_sysconfdir}/sysconfig/%{name}
%{_unitdir}/pads.service
%{_bindir}/pads
%{_bindir}/pads-report
%{_mandir}/*/*

%changelog
