Group: Office
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary:    Command line calendar that displays holidays and events
Name:       pal
Version:    0.4.3
Release:    alt2_32
License:    GPLv2+
Url:        http://palcal.sourceforge.net
Source0:    http://downloads.sourceforge.net/palcal/pal-%{version}.tgz

Patch0: pal-0.4.3-bz1037238.patch

BuildRequires:  gcc
BuildRequires: glib2-devel libgio libgio-devel
BuildRequires: libncurses++-devel libncurses++w-devel libncurses-devel libncursesw-devel libtic-devel libtinfo-devel
BuildRequires: libreadline-devel
BuildRequires: gettext-tools
Source44: import.info

%description
Pal is command-line calendar program for Unix/Linux that can keep track of
events.  It has similarities with the Unix cal command, the more complex GNU
gcal program, and the calendar program distributed with the BSDs.

%prep
%setup -q
sed -i 's/-o\ root//g' src/Makefile
sed -i 's/-o\ root//g' src/convert/Makefile
sed -i 's/G_CONST_RETURN/const/' src/*.c
%patch0 -p1

%build
make DEBUG=1 -C src OPT="$RPM_OPT_FLAGS"

%install
make -C src DESTDIR="$RPM_BUILD_ROOT" install-no-rm
rm -rf $RPM_BUILD_ROOT%{_docdir}/%{name}*
%find_lang %{name}

%files -f %{name}.lang
%doc doc/example.css COPYING ChangeLog
%config(noreplace) %{_sysconfdir}/pal.conf
%{_bindir}/pal
%{_bindir}/vcard2pal
%{_datadir}/pal
%{_mandir}/man1/pal.1*
%{_mandir}/man1/vcard2pal.1*

%changelog
