Group: System/Base
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Test/More.pm)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name: pam_afs_session
Summary: AFS PAG and AFS tokens on login
Version: 2.6
Release: alt2_21
License: MIT
URL: https://www.eyrie.org/~eagle/software/pam-afs-session/
Source: https://archives.eyrie.org/software/afs/pam-afs-session-%{version}.tar.gz
BuildRequires:  gcc
BuildRequires: libpam0-devel
BuildRequires: libkrb5-devel
Source44: import.info
%description
pam-afs-session is a PAM module intended for use with a Kerberos v5 PAM module
to obtain an AFS PAG (Process Authentication Group) and AFS tokens on login. It
puts every new session in a PAG regardless of whether it was authenticated with
Kerberos and runs a configurable external program to obtain tokens.

%define pamdir /%{_lib}/security

%prep
%setup -q -n pam-afs-session-%{version}

# remove non-redhat examples
find examples -mindepth 1 -maxdepth 1 -not -name "redhat" -exec rm -rf {} ';'

%build
%configure --libdir=/%{_lib} --with-aklog=%{_bindir}/aklog
%make_build

%install
make install DESTDIR=$RPM_BUILD_ROOT
rm -f $RPM_BUILD_ROOT%{pamdir}/*.la

%files
%{!?_licensedir:%global license %%doc}
%doc --no-dereference LICENSE
%doc NEWS README TODO examples
%{pamdir}/pam_afs_session.so
%{_mandir}/man5/pam_afs_session.5*

%changelog
