# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define real_version 0.7

Name:    parprouted
Version: 0.70
Release: alt1_20
License: GPLv2
Summary: Proxy ARP IP bridging daemon
Group:   Networking/WWW
URL:     http://www.hazard.maks.net/
Source0: http://www.hazard.maks.net/parprouted/%{name}-%{real_version}.tar.gz
Source1: scripts.tar.gz
Patch:   makefile.patch

Requires: arpd iproute2
Requires: procps
Requires: tunctl

BuildRequires: gcc
Source44: import.info

%description
parprouted is a daemon for transparent IP (Layer 3) proxy ARP bridging.
Unlike standard bridging, proxy ARP bridging allows to bridge Ethernet
networks behind wireless nodes. Normal L2 bridging does not work between
wireless nodes because wireless does not know about MAC addresses used
in the wired Ethernet networks. Also this daemon is useful for making
transparent firewalls.

%prep
%setup -q -n %{name}-%{real_version}
%patch -p1 -b .makefile

%build
make %{?_smp_mflags} CFLAGS="%{optflags}"

%install
make install DESTDIR=%{buildroot}
tar -zxf %{SOURCE1} -C %{buildroot}%{_bindir}

%files
%doc CHANGELOG COPYING README
%{_bindir}/%{name}*
%{_mandir}/man8/%{name}.8*

%changelog
