Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global         gituser         CoreSecurity
%global         gitname         pcapy
%global         commit          b91a418374d1636408c435f11799ef725ef70097
%global         commitdate      20170116

%global         shortcommit     %(c=%{commit}; echo ${c:0:7})
%global         sum             A Python interface to libpcap

%global         with_tests      0



Name:           pcapy
Version:        0.11.5
Release:        alt5_23
Summary:        %{sum}

License:        Apache-1.1
URL:            https://www.coresecurity.com/corelabs-research/open-source-tools/pcapy
#               http://oss.coresecurity.com/projects/pcapy.html
#               https://github.com/CoreSecurity/pcapy/releases
#Source0:       https://github.com/%%{gituser}/%%{gitname}/archive/%%{commit}/%%{name}-%%{version}-%%{shortcommit}.tar.gz
Source0:        https://github.com/%{gituser}/%{gitname}/archive/%{version}.tar.gz#/%{gitname}-%{version}.tar.gz

# Fix FTBFS issue with setuptools >= 61.0.0
# Upstream issue: https://github.com/helpsystems/pcapy/issues/73
# Fix backported from the fork: https://github.com/stamparm/pcapy-ng/commit/84a15d2faefaae410198f5739d6ed3c69daa17ec
Patch0:         fix-setuptools-build.patch
Patch1:         py_ssize_t.patch
Patch2:         py313.patch

BuildRequires:  gcc-c++
BuildRequires:  python3-devel
BuildRequires:  python3-module-pkg_resources python3-module-setuptools
BuildRequires:  libpcap-devel
Source44: import.info

%description
Pcapy is a Python extension module that interfaces with the libpcap
packet capture library. Pcapy enables python scripts to capture packets
on the network. Pcapy is highly effective when used in conjunction with 
a packet-handling package such as Impacket, which is a collection of 
Python classes for constructing and dissecting network packets.



#===== the python3 package definition
%package -n python3-module-pcapy
Group: Other
Summary:        %{sum}

%{?python_provide:%python_provide python3-%{gitname}}

%description -n python3-module-pcapy
Python3 package of %{gitname}.
Pcapy is a Python extension module that interfaces with the libpcap
packet capture library. Pcapy enables python scripts to capture packets
on the network. Pcapy is highly effective when used in conjunction with
a packet-handling package such as Impacket, which is a collection of
Python classes for constructing and dissecting network packets.



%prep
%setup -q

%patch0  -p1
%patch1  -p1
%patch2  -p0

%build
%python3_build

#fix encodings
sed -i 's/\r//' LICENSE
sed -i 's/\r//' README
sed -i 's/\r//' pcapy.html
iconv -f IBM850 -t UTF8 pcapy.html > pcapy.html.tmp
mv pcapy.html.tmp pcapy.html


%install
%python3_install

rm -rf %{buildroot}/usr/share/doc/pcapy

%files -n python3-module-pcapy
%doc --no-dereference LICENSE
%doc README pcapy.html
%{python3_sitelibdir}/*


%changelog
