Group: Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global driver asekey
%global dropdir %(pkg-config libpcsclite --variable usbdropdir 2>/dev/null)
%global rulesdir %(pkg-config udev --variable udevdir 2>/dev/null)/rules.d

Name:           pcsc-lite-%{driver}
Version:        3.7
Release:        alt2_23
Summary:        ASEKey USB token driver
# 92_pcscd_asekey.rules:    LGPLv2+
# other files:              BSD
License:        BSD and LGPLv2+
# The address does not exist anymore.
URL:            http://www.athena-scs.com/
Source0:        http://www.athena-scs.com/docs/reader-drivers/%{driver}-%(echo %{version}|tr '.' '-')-tar.bz2
# Fix PCSC bundle
Patch0:         %{driver}-3.7-bundle.patch
# Fix GCC-8 warnings
Patch1:         %{driver}-3.7-Fix-compiler-warnings.patch
BuildRequires:  gcc
BuildRequires:  libusb-compat-devel
BuildRequires:  pkgconfig(libpcsclite) >= 1.8.0
BuildRequires:  pkgconfig(udev)
BuildRequires:  sed
Requires:       pcsc-lite >= 1.8.0
Provides:       pcsc-ifd-handler

%global __provides_exclude_from %{?__provides_exclude_from:%{__provides_exclude_from}|}^%{dropdir}
Source44: import.info

%description
This is a driver for the ASEKey USB cryptographic token in form of a PCSC
plug-in.

%prep
%setup -q -n %{driver}-%{version}
%patch0 -p1
%patch1 -p1


%build
%configure --with-udev-rules-dir="%{rulesdir}"
# Work around bug #893432:
# All platforms calls the compiler without "-gnu" suffix, except armv7hl which
# uses "-gnueabi" suffix.
%ifarch armv7hl
sed -i -e '/^BUILD=/ s/-gnu$/-gnueabi/' Makefile.inc
%else
sed -i -e '/^BUILD=/ s/-gnu$//' Makefile.inc
%endif
%{make_build}

%install
%{makeinstall_std}

%post
/bin/systemctl try-restart pcscd.service >/dev/null 2>&1 || :

%postun
/bin/systemctl try-restart pcscd.service >/dev/null 2>&1 || :

%files
%doc --no-dereference LICENSE
%doc ChangeLog README
%{dropdir}/ifd-ASEKey.bundle
%{rulesdir}/*

%changelog
