Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# spec file for package pdf-stapler
#
%global commit 875325103234b4a3ed96a4a5167ff78c291edbff
%global shortcommit %(c=%{commit}; echo ${c:0:7})
%global commitdate 20191215

Name:           pdf-stapler
Version:        1.0.0
Release:        alt2_0.13.%{commitdate}git%{shortcommit}
Summary:        Tool for manipulating PDF documents from the command line
License:        BSD
URL:            https://github.com/hellerbarde/stapler
Source0:        https://github.com/hellerbarde/stapler/archive/stapler-%{commit}.tar.gz
BuildArch:      noarch
BuildRequires:  python3-devel
BuildRequires:  python3-module-pkg_resources python3-module-setuptools
Requires:       python3-module-more-itertools
Requires:       python3-module-staplelib = %{version}-%{release}
Source44: import.info

%description
pdf-stapler is the Fedora package for stapler, the opensource python
project which provides a commandline tool that staples, deletes,
concatenates and shuffles documents in the Portable Document Format
(PDF). It is an alternative to PDFtk.

From the project git page:

Philip Stark found pypdf, a PDF library written in pure Python. He
couldn't find a tool which actually used the library, so he started 
writing his own.

This version of stapler is Fred Wenzel's fork of the project, with
a completely refactored source code, tests, and added functionality.

%package -n python3-module-staplelib
Group: Other
Summary:        Module staplelib of pdf-stapler
Requires:       python3-module-PyPDF2
%{?python_provide:%python_provide python3-staplelib}

%description -n python3-module-staplelib
%{summary}.

%prep
%setup -q -n  stapler-%{commit}
sed -i 's|"PyPDF2>=1.24"||' setup.py
# Remove upper limit from more-itertools
# https://github.com/hellerbarde/stapler/issues/71
sed -i 's|"more-itertools>=2.2,<6.0.0"|"more-itertools>=2.2"|' setup.py

%build
%python3_build 

#%check
#%{__python3} setup.py test

%install
%python3_install

#mv $RPM_BUILD_ROOT/%{_bindir}/stapler-%{commit} $RPM_BUILD_ROOT/%{_bindir}/%{name}
rm %{buildroot}%{_bindir}/stapler
# Fedora already has a stapler package so this "stapler" package is renamed
# pdf-stapler

%files
%{_bindir}/%{name}
%doc README.rst
%doc --no-dereference LICENSE

%files -n python3-module-staplelib
%{python3_sitelibdir_noarch}/stapler-%{version}*.egg-info
%{python3_sitelibdir_noarch}/staplelib/
%doc --no-dereference LICENSE

%changelog
