%define module_name AVLTree
# BEGIN SourceDeps(oneline):
BuildRequires: libsowing-devel perl(Benchmark.pm) perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(List/Util.pm) perl(Test/Deep.pm) perl(Test/LeakTrace.pm) perl(Test/More.pm) perl(XSLoader.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1.7
Release: alt4
Summary: Perl extension for efficient creation and manipulation of AVL balanced binary trees.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AV/AVULLO/%{module_name}-%{version}.tar.gz

%description
This module provides a simple and fast implementation of AVL balanced binary trees.
It uses the Perl XS extension mechanism by providing a tiny wrapper around 
an efficient C library which does the core of the work. Preliminary benchmarking 
shows this module one order of magnitude faster than a pure perl implementation.

The nodes of an AVL tree object can hold any kind of item, as long as each 
one of these can be used or has an element that can be use to define a partial order 
on the set of possible items. This is specified by providing, upon tree construction,
a reference to a function for comparing any two of the possible items.

The underlying C library is a reinterpretation of the C library originally 
developed by Julienne Walker http://www.eternallyconfuzzled.com/jsw_home.aspx. 
This library has been adapted for dealing directly with Perl (SV) variables.

The module at the moment is in beta stage but it is usable. It provides methods 
for creating and querying an AVL tree, get its size and insert and remove elements 
from it. No methods exist to traverse the tree at this stage, but I promise this
functionality is going to be implemented very soon.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes TODO ignore.txt README
%perl_vendor_archlib/A*
%perl_vendor_autolib/*

%changelog
