%define module_name AWS-Lambda-Quick
# BEGIN SourceDeps(oneline):
BuildRequires: perl(AWS/CLIWrapper.pm) perl(Archive/Zip.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FindBin.pm) perl(HTTP/Tiny.pm) perl(JSON/PP.pm) perl(Mo.pm) perl(Path/Tiny.pm) perl(Test/More.pm) perl(Test/TempDir/Tiny.pm) perl(Test2/V0.pm) perl(autodie.pm) perl(base.pm) perl(lib.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0002
Release: alt1
Summary: quickly create a REST accesible AWS Lambda function
Group: Development/Perl
License: perl
URL: http://metacpan.org/release/AWS-Lambda-Quick

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MA/MARKF/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module allows you to very quickly create a Perl based AWS
Lambda function which can be accessed via HTTP.

Coding Lambda functions in Perl is straight forward: You need only
implement a script with the one `handler' function that returns the
expected data structure as described in the the AWS::Lambda manpage
documentation.

The hard part is configuring AWS to execute the code.  Traditionally
you have to complete the following steps.

=over

=item Create a zip file containing your code

=item Create (or update) an AWS Lambda function with this zip file

=item Create a REST API with AWS Gateway API

=item Configure a resource for that REST API for this script

=item Set up a method and put method response for that resource

=item Manage an integration and integration response for that resource

=back

And then debug all the above things, a lot, and google weird error
messages it generates when you inevitably make a mistake.

This module provides a way to do all of this completely transparently
just by executing your script, without having to either interact with
the AWS Management Console nor directly use the awscli utility.

Simply include this module at the top of your script containing the
handler function:

    use AWS::Lambda::Quick (
        name => 'random-lottery-numbers',
    );

And then execute it locally.  Rather than running as normal your script
will instead upload itself to AWS as a Lambda function (modifying
itself so that it no longer has a dependency on AWS::Lambda::Quick) and
handle all the other steps needed to make itself web accessible.
Running the script locally subsequent times will update the code and
AWS settings.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md CONTRIBUTING.md LICENSE
%perl_vendor_privlib/A*

%changelog
