# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(IO/Uncompress/Bunzip2.pm) perl(IO/Uncompress/Inflate.pm) perl(JSON/MaybeXS.pm) perl(List/Util.pm) perl(Test/More.pm) perl(UUID/Tiny.pm) perl(Cpanel/JSON/XS.pm) perl(JSON/PP.pm) perl(JSON/XS.pm)
# END SourceDeps(oneline)
%define module_version 0.001
%define module_name Aard
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001
Release: alt1
Summary: Read aarddict dictionaries
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MG/MGV/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Aard is a module for reading files in the Aard Dictionary format (.aar). A dictionary is an array of *(key, article)* pairs, with some associated metadata.

=over

=item new(*filename*)

Creates a new Aard object for the given file.

=item fh

Returns the open filehandle to the dictionary.

=item count

Returns the number of entries in this dictionary.

=item key(*index*)

Returns the key of the *index*th element. This method caches the keys.

=item article(*index*)

Returns the article of the *index*th element. This method caches the articles.

=item uuid

Returns the UUID of this dictionary as a binary string. This is a value shared by all volumes of the same dictionary.

=item uuid_string

Returns the UUID of this dictionary as a human-readable string. This is a value shared by all volumes of the same dictionary.

=item volume

Returns the volume number of this file.

=item total_volumes

Returns the total number of volumes for this dictionary.

=item meta

Returns the raw metadata as a hashref.

=item article_count

Returns the number of unique articles in this volume (if article_count_is_volume_total is true) or in this dictionary (otherwise).

=item article_count_is_volume_total

Returns true if article_count means number of articles in this volume. This is always true since aardtools 0.9.0.

=item index_language

Returns the dictionary's "from" language (two or three letter ISO code)

=item article_language

Returns the dictionary's "to" language (two or three letter ISO code)

=item title

Returns the dictionary title

=item version

Returns the dictionary version

=item description

Returns the dictionary description

=item copyright

Returns the copyright notice

=item license

Returns the full license text

=item source

Returns the dictionary data source

=back
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/A*

%changelog
