Epoch: 1
Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
BuildRequires: gcc-c++
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Acme-Alien-DontPanic
%global cpan_version 2.7200
Version:        2.720.0
Release:        alt1_5
Summary:        Test module for Alien::Base
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/Acme-Alien-DontPanic
Source0:        https://cpan.metacpan.org/authors/id/P/PL/PLICEASE/Acme-Alien-DontPanic-%{cpan_version}.tar.gz
# Full-arch for files storing architecture-specific paths
%global debug_package %{nil}
BuildRequires:  coreutils
BuildRequires:  gcc
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl
# Alien::Build::MM version from Alien::Build in Makefile.PL
BuildRequires:  perl(Alien/Build/MM.pm)
# Alien::Build::Plugin::Digest::Negotiate not used
BuildRequires:  perl(Alien/Build/Plugin/Build/Autoconf.pm)
BuildRequires:  perl(Alien/Build/Plugin/Probe/CommandLine.pm)
BuildRequires:  perl(alienfile.pm)
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Use a system dontpanic library instead of downloading it from the Internet at
# build time.
BuildRequires:  pkgconfig(dontpanic)
# Run-time:
BuildRequires:  perl(Alien/Base.pm)
BuildRequires:  perl(base.pm)
# Tests:
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(File/Temp.pm)
BuildRequires:  perl(Inline.pm)
BuildRequires:  perl(Inline/C.pm)
BuildRequires:  perl(Inline/CPP.pm)
BuildRequires:  perl(Path/Tiny.pm)
BuildRequires:  perl(Test2/V0.pm)
BuildRequires:  perl(Test/Alien.pm)
BuildRequires:  perl(Test/Alien/Diag.pm)
# Optional tests:
# Test::More not helpful
Requires:       perl(Alien/Base.pm) >= 2.590
# The maning of the package is have dontpanic library installed and
# application being able to build against it. Because we use system dontpanic
# library instead of bundling one that had been dowloaded and compiled at
# build time, we need to explicitly run-require the developmental files of the
# library.
Requires:       pkgconfig(dontpanic)

# Remove under-specified dependencies

Source44: import.info
%filter_from_requires /^perl(\(Alien.Base\|Test2.V0\).pm)/d

%description
This Perl module is a toy module to test the efficacy of the Alien::Base system.

%package tests
Group: Development/Perl
Summary:        Tests for %{name}
BuildArch:      noarch
Requires:       %{name} = %{?epoch:%{epoch}:}%{version}-%{release}
Requires:       coreutils
Requires:       perl(Inline/C.pm)
Requires:       perl(Inline/CPP.pm)
Requires:       perl(Test2/V0.pm) >= 0.000.121

%description tests
Tests from %{name}. Execute them
with "%{_libexecdir}/%{name}/test".

%prep
%setup -q -n Acme-Alien-DontPanic-%{cpan_version}
# Help generators to recognize Perl scripts
for F in t/*.t; do
    perl -i -MConfig -ple 'print $Config{startperl} if $. == 1 && !s{\A#!\s*perl}{$Config{startperl}}' "$F"
    chmod +x "$F"
done

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
# %{_fixperms} %{buildroot}/*
# Install tests
mkdir -p %{buildroot}%{_libexecdir}/%{name}
cp -a t %{buildroot}%{_libexecdir}/%{name}
cat > %{buildroot}%{_libexecdir}/%{name}/test << 'EOF'
#!/bin/bash
# ExtUtils::CBuilder::have_compiler() writes into CWD
# <https://github.com/Perl/perl5/issues/15697>.
set -e
DIR=$(mktemp -d)
cp -a %{_libexecdir}/%{name}/* "$DIR"
pushd "$DIR"
prove -I . -j "$(getconf _NPROCESSORS_ONLN)"
popd
rm -rf "$DIR"
EOF
chmod +x %{buildroot}%{_libexecdir}/%{name}/test

%check
export HARNESS_OPTIONS=j$(perl -e 'if ($ARGV[0] =~ /.*-j([0-9][0-9]*).*/) {print $1} else {print 1}' -- '%{?_smp_mflags}')
make test

%files
%doc --no-dereference LICENSE
%doc Changes README
%{perl_vendor_archlib}/auto/*
%{perl_vendor_archlib}/Acme

%files tests
%{_libexecdir}/%{name}

%changelog
