%define module_name Acme-CPANModules-CheckingModuleInstalledLoadable
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Foo/Bar.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Module/Load/Conditional.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: Checking if a module is installed or loadable
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Acme-CPANModules-CheckingModuleInstalledLoadable

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Checking if a module is installed or loadable.

If you simply want to check that a module's `.pm' file is locatable in `@INC',
you can just do something like:

 my $mod = "Foo/Bar.pm";
 for my $dir (@INC) {
     next if ref $dir;
     if (-f "$dir/$mod") {
         print "Module $mod is installed";
         last;
     }
 }

Or you can use something like the Module::Path manpage or the Module::Path::More manpage which
does similar to the above.

A module can also be loaded from a require hook in ~@INC~ (like in the case of
fatpacked or datapacked script) and the above methods does not handle it.
Instead, you'll need to use the Module::Load::Conditional manpage's `check_install' or
the Module::Installed::Tiny manpage's `module_installed':

 use Module::Load::Conditional qw(check_install);
 if (check_install(module => "Foo::Bar")) {
     # Foo::Bar is installed
 }

The above does not guarantee that the module will be loaded successfully. To
check that, there's no other way but to actually try to load it:

 if (eval { require Foo::Bar; 1 }) {
     # Foo::Bar can be loaded (and was loaded!)
 }

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/A*

%changelog
