%define module_name Acme-CPANModules-DataStructureWalker
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.003
Release: alt1
Summary: Modules that traverse your data structure
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Acme-CPANModules-DataStructureWalker

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Modules that traverse your data structure.

This list catalogs modules that let you traverse your data structure by visiting
each node/item: each element of an array, each key/value pair of a hash,
recursively. Sort of like the File::Find manpage for your data instead of filesystem.
These modules can be used for searching or modifying your data.

Many modules in this mimic Perl's `map' interface, for example: the Data::Rmap manpage,
the Data::Dmap manpage, the Data::Traverse manpage. These modules differ in the details: in
how you specify option to skip unsupported types of references, whether some let
you control the recursion (e.g. Data::Rmap's and Data::Dmap's `cut'),

the Data::Walk manpage models its interface on File::Find. It lets you choose whether
you want to go depth-first or breadth-first.

Benchmarks for these modules coming soon.

Related modules:

the Data::Clean manpage can be used to clean/sanitize your data structure more
performantly compared to your manual walking (e.g. using Data::Rmap). It works
by generating Perl code specifically for your cleaning needs.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/A*

%changelog
