# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm)
# END SourceDeps(oneline)
%define module_name Acme-CPANModules-FormattingDate
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: List of various methods to format dates
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Acme-CPANModules-FormattingDate

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Overview

Date formatting modules can be categorized by their expected input format and
the formatting styles.

Input format: Some modules accept date in the form of Unix epoch (an integer),
or a list of integer produced by running the epoch through the builtin gmtime()
or localtime() function. Some others might expect the date as the DateTime manpage
object. For formatting style: there's strftime in the the POSIX manpage core module,
and then there's the others.

This list is organized using the latter criteria (formatting style).

strftime (and variants)

The the POSIX manpage module provides the `strftime()' routine which lets you format
using a template string containing sprintf-style conversions like `%%Y' (for
4-digit year), `%%m' (2-digit month number from 1-12), and so on. There's also
the Date::strftimeq manpage which provides an extension to this.

You can actually add some modifiers for the conversions to set
width/zero-padding/alignment, like you can do with sprintf (e.g. `%%03d'
supposing you want 3-digit day of month numbers). But this feature is
platform-dependent.

yyyy-mm-dd template

This "yyyy-mm-dd" (for lack of a better term) format is much more commonly used
in the general computing world, from spreadsheets to desktop environment clocks.
And this format is probably older than strftime. The template is more intuitive
to use for people as it gives a clear picture of how wide each component (and
the whole string) will be.

There are some modules you can use to format dates using this style. First of
all there's the Date::Formatter manpage. I find its API a little bit annoying, from the
verbose date component key names and inconsistent usage of plurals, to having to
use a separate method to "create the formatter" first.

PHP

PHP decided to invent its own date template format. Its `date()' function
accepts template string in which you specify single letter conversions like `Y'
(for 4-digit year),'y`(2-digit year), and so on. Some of the letters mean the
same like their counterpart in strfti...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/A*

%changelog
