# BEGIN SourceDeps(oneline):
BuildRequires: perl(Acme/CPANModulesUtil/Misc.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm)
# END SourceDeps(oneline)
%define module_name Acme-CPANModules-LoadingModules
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001
Release: alt1
Summary: List of modules to load other Perl modules
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Acme-CPANModules-LoadingModules

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Basics

the Module::Load manpage is basically just a thin wrapper over Perl's builtin
`require()' to translate between module name and path name, since the
traditional behavior of `require()' is to expect module name in bareword form
but path name in string form. This confusion will likely be fixed in future perl
versions. For example, see PPC 0006 [1].

[1] https://github.com/Perl/PPCs/blob/main/ppcs/ppc0006-load-module.md

Installing modules automatically on demand

Since Perl provides require hooks, one can trap the module loading process and
check for an uninstalled module and attempt to install it automatically on
demand when a code wants to load that module. Probably not suitable for use in
production. See separate list: the Acme::CPANModule::ModuleAutoinstallers manpage.

Loading module on demand

Aside from require hook, Perl also provides the AUTOLOAD mechanism (see
`perlsub' documentation for more details). This lets you catch unknown function
being called and lets you attempt to load a module that might provide that
function. It is not exactly "loading modules on demand" but close enough for a
lot of cases. See separate list: the Acme::CPANModule::ModuleAutoloaders manpage.

Loading multiple modules at once

the all manpage requires all packages under a namespace. It will search the filesystem
for installed module source files under a specified namespace and load them all.

the lib::require::all manpage loads all modules in a directory.

Logging module loading

the Require::HookChain::log::logger manpage

the Require::HookChain::log::stderr manpage

Preventing loading certain modules

the lib::filter manpage, the lib::disallow manpage

Require hook frameworks

These frameworks let you create require hook more easily.

the Require::Hook manpage

the Require::Hook::More manpage

the Require::HookChain manpage

Specifying relative paths

the lib::relative manpage

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/A*

%changelog
