# BEGIN SourceDeps(oneline):
BuildRequires: perl(Acme/CPANModulesUtil/Misc.pm) perl(ExtUtils/MakeMaker.pm) perl(File/MimeInfo.pm) perl(File/MimeInfo/Magic.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(LWP/MediaTypes.pm) perl(MIME/Type/FileName.pm) perl(MIME/Types.pm) perl(Media/Type/Simple.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Acme-CPANModules-MIMETypes
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001
Release: alt1
Summary: List of modules to work with MIME types
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Acme-CPANModules-MIMETypes

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
All recipes are categorized by tasks, then by most recommended module.

1. Finding out filename extensions for a certain MIME type

1a. With the File::MimeInfo manpage (uses system's type database):

 use File::MimeInfo qw(extensions);
 $ext  = extensions("image/jpeg"); # => "jpeg"
 @exts = extensions("image/jpeg"); # => ("jpeg", "jpe", "jpg")

1b. With the MIME::Types manpage (comes with its own type database):

 use MIME::Types;
 my $mt = MIME::Types->new->type("image/jpeg") or die "Unknown MIME type";
 my @exts = $m->extensions; # => ("jpeg", "jpg", "jpe", "jfif", "jfif-tbnl")

1c. With the Media::Type::Simple manpage (can uses system's `/etc/mime.types'):

 use Media::Type::Simple;
 $ext  = ext_from_type("image/jpeg"); # => "jpeg"
 @exts = ext_from_type("image/jpeg"); # => ("jpeg", "jpg", "jpe", "jfif")

2. Finding out the MIME type associated with a certain filename extension

2a. With MIME::Types:

 use MIME::Types;
 my $mt = MIME::Types->new->mimeTypeOf("gif") or die "Unknown MIME type";
 say "$mt" ;# => "image/gif"

2b. With Media::Type::Simple:

 use Media::Type::Simple;
 $type = type_from_ext("jpg"); # => "image/jpeg"

2c. With the MIME::Type::FileName manpage (comes with its own type database, last updated 2012):

 use MIME::Type::FileName;
 my $mimetype = MIME::Type::FileName::guess ("my-file.xls") or die "Unknown MIME type";

3. Guessing MIME type of a file based on its extension

3a. With File::MimeInfo:

 use File::MimeInfo;
 my $mime_type = mimetype('test.png') or die "Unknown MIME type";

3b. With the LWP::MediaTypes manpage (comes with its own type database):

 use LWP::MediaTypes;
 my $type = LWP::MediaTypes::guess_media_type("file.xls") or die "Unknown MIME type";

4. Guessing MIME type of a file based on its content

4a. Using the File::MimeInfo::Magic manpage (same interface as File::MimeInfo):

 use File::MimeInfo::Magic;
 
 $type = mimetype("file.jpg"); # => "image/jpeg"
 
 # For symlink, will return "octet/symlink". To follow symlink, open file and
 # pass filehandle.
 open my $fh...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/A*

%changelog
