%define module_name Acme-CPANModules-ModernPreambles
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Modern/Perl.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: Modules that offer modern preambles
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Acme-CPANModules-ModernPreambles

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Modules that offer modern preambles.

The overwhelming convention for coding Perl properly code is to at least add the
following preamble:

 use strict;
 use warnings;

to the beginning of your code. But some people say that's not enough, and they
develop modules/pragmas that bundle the above incantation plus some additional
stuffs. For example:

 use Modern::Perl '2018';

is equivalent to:

 use strict;
 use warnings;
 use feature ':5.26';
 mro::set_mro( scalar caller(), 'c3' );

I think the Modern::Perl manpage is one of the first to popularize this modern preamble
concept and a bunch of similar preambles emerged. This list catalogs them.

Meanwhile, you can also use:

 use v5.12; # enables strict and warnings, as well as all 5.12 features (see the feature manpage for more details on new features of each perl release)

and so on, but this also means you set a minimum Perl version.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/A*

%changelog
