# BEGIN SourceDeps(oneline):
BuildRequires: perl(Acme/CPANModulesUtil/Misc.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Acme-CPANModules-MultipleDispatch
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001
Release: alt1
Summary: List of modules to do smart matching
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Acme-CPANModules-MultipleDispatch

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
About multiple dispatch

Multiple dispatch is a technique where you can define /multiple/ functions (or
methods) of the same name but with different signatures (e.g. different type of
arguments, different number of arguments) and the runtime will choose
(/dispatch/) the correct function by matching the signature of the caller to
that of the defined functions.

This technique has several benefits, mostly simplifying user code particularly
when dealing with different types/arguments, because you are deferring the
checks to the runtime. For example, if you create a function to concat two
strings:

 function combine(Str a, Str b) {
     a + b;
 }

and later wants to support some other types, instead of peppering the original
function with `if' statements, you can just supply additional functions with the
same name but with different arguments you want to support:

 function combine(Num a, Num b) {
     a.as_str() + b.as_str();
 }
 
 function combine(File a, File b) {
     a.open().read() + b.open().read();
 }

Some languages, particularly strongly-typed ones, support multiple dispatch:
Julia, C#, Common Lisp, Groovy. Raku (Perl 6) also supports multiple dispatch.

Perl 5 does not. But some modules will allow you to fake it.

Modules

the Multi::Dispatch manpage. By DCONWAY.

the Dios manpage. Also by DCONWAY. An object system which supports multiple dispatch.

the Class::Multimethods manpage. Older module by DCONWAY.

Keywords

multi dispatch, multisub, multimethod.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/A*

%changelog
