%define module_name Acme-CPANModules-OneAndTwoDecimalDigitsVersionTrap
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.003
Release: alt1
Summary: Chronicle CPAN distributions which have been trapped by the one- and two decimal digits versioning ...
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Acme-CPANModules-OneAndTwoDecimalDigitsVersionTrap

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Chronicle CPAN distributions which have been trapped by the one- and two decimal digits versioning scheme.

The x.y and x.yy versioning scheme used in Perl distribution has a trap: when
you release a new version by incrementing the patchlevel part into x.y.z and
x.yy.z, the new version number will be *less* than x.y and x.yy because x.y and
x.yy will numify to x.y00 and x.yy0 respectivey; while x.y.z and x.yy.z will
numify to x.00y.z and x.0yy, respectively.

So if you release Acme-MyDist-0.1 (numifies to 0.100000) then Acme-MyDist-0.1.1
(0.001001), or Acme-MyDist-0.01 (0.010000) then Acme-MyDist-0.01.1 (0.001001),
PAUSE will *refuse* to index your new version because of "decreasing version
number."

This does *not* happen when you release Acme-MyDist-0.001 (0.001000) and then
Acme-MyDist-0.001.1 (0.001001).

This thing is peculiar to Perl, and is not intuitive. Consequently, sometimes
CPAN authors are not familiar with this and thus have fallen into this trap.

This list chronicles distributions which have been trapped by this.

For a bit more details, see
https://perlancar.wordpress.com/2018/09/10/should-i-choose-x-yy-or-x-yyy-versioning-scheme-for-my-perl-module/
and also the version manpage.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/A*

%changelog
