%define module_name Acme-CPANModules-SmartMatch
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Acme/CPANModulesUtil/Misc.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.007
Release: alt1
Summary: List of modules to do smart matching
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Acme-CPANModules-SmartMatch

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
About smart match

Smart matching, via the operator `~~', was introduced in perl 5.10 (released
2007). It's probably inspired by Perl 6 (now called Raku)'s `given/when' and/or
Ruby's `case' and `===' operator that can "do the right/smart thing" in a `case'
statement. Smart matching was indeed introduced along the new `switch' in perl
5.10.

What can smart match do? A whole lot. It can do string equality like `eq' if
given a string on the left hand side and a string on the right hand side. Or it
can do numeri equality like `==' when both sides are numbers. It can do regex
matching like `=~' if the left hand side is a scalar and the right hand side is
a regexp.

But wait, there's (much) more. Interesting things begin when the left/right hand
side is an array/hash/code/object. `$str ~~ @ary', probably the most common
use-case for smart matching, can do value-in-array checking, equivalent to `grep
{ $str eq $_ } @ary' but with short-circuiting capability. Then there's `$re ~~
@ary' which can perform regex matching over the elements of array. Now what
about when the right hand side is an arrayref or hashref? Or the left hand side?
What if the array is an array of regexes? Or a mix of other types?

You need a full-page table as a reference of what will happen in smart matching,
depending on the combination of operands. Things got complex real fast.
Behaviors were changed from release to release, starting from 5.10.1. Then
nobody was sure what smart matching should or should not do exactly.

In the end almost everyone agrees that smart matching is a bad fit for a weakly
typed language like Perl. The programmer needs to be explicit on what type of
operation should be done by specifying the appropriate /operator/ (e.g. `==' vs
`eq') instead of the operator deducing what operation needs to be done depending
on the operand, because in Perl the operand's type is unclear. Mainly, a scalar
can be a string, or a number, or a bool, or all.

The roadmap to removal

In perl 5.18 (2013), 6 years after being introduced and u...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/A*

%changelog
