# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm)
# END SourceDeps(oneline)
%define module_name Acme-CPANModules-TemporaryChdir
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001
Release: alt1
Summary: List of modules to change directory temporarily
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Acme-CPANModules-TemporaryChdir

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Changing directory can be tricky if you are doing it in a transaction or inside
a routine where you need to restore the previous working directory whether your
main action succeeds or not. Forgetting doing it and it will cause unexpected
behavior for the user calling your code.

Restoring previous directory can be as simple as:

 use Cwd qw(getcwd);
 
 my $prevcwd = getcwd();
 eval {
     # do some stuffs that might die ...
 };
 # check success status ...
 chdir $prevcwd or die "Can't chdir back to '$prevcwd': $!";

but it can get tedious. Some modules can help. These modules employ one of
several mechanisms provided by Perl:

1) Tied scalar, where reading from the scalar retrieves the current working
directory and writing to it changes the working directory. The user can set the
magic variable locally and have Perl restore the old value. Modules that use
this technique include: the File::chdir manpage.

2) An object, where its constructor records the current working directory and
its DESTROY restores the previously recorded working directory. The user can
create a lexically scoped object that can change directory but restores the
previous working directory when the object goes out of scope. Modules that use
this technique include: the File::pushd manpage and the Dir::TempChdir manpage.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/A*

%changelog
