%define module_name Acme-CPANModules-WorkingWithXLS
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Acme/CPANModulesUtil/Misc.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(alias/module.pm) perl(strict.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.005
Release: alt1
Summary: Working with Excel formats (XLS, XLSX) or other spreadsheet formats like LibreOffice Calc (ODS)
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Acme-CPANModules-WorkingWithXLS

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The following are tools (programs, modules, scripts) to work with Excel formats
(XLS, XLSX) or other spreadsheet formats like LibreOffice Calc (ODS).

Parsing

the Spreadsheet::Read manpage is a common-interface front-end for
the Spreadsheet::ReadSXC manpage (for reading LibreOffice Calc ODS format) or one of
the Spreadsheet::ParseExcel manpage, the Spreadsheet::ParseXLSX manpage, or Spreadsheet::XLSX
(for reading XLS or XLSX, although Spreadsheet::XLSX is strongly discouraged
because it is a quick-and-dirty hack). Spreadsheet::Read can also read CSV via
Text::CSV_XS. The module can return information about cell's attributes
(formatting, alignment, and so on), merged cells, etc.

Getting information

the Spreadsheet::Read manpage

the xls-info manpage from the App::XLSUtils manpage

Iterating/processing with Perl code

the XLSperl manpage CLI from the App::XLSperl manpage lets you iterate each cell (with
'XLSperl -ne' or row with 'XLSperl -ane') with a Perl code, just like you would
each line of text with `perl -ne' (in fact, the command-line options of XLSperl
mirror those of perl). Only supports the old Excel format (XLS not XLSX). Does
not support LibreOffice Calc format (ODS). If you feed it unsupported format, it
will fallback to text iterating, so if you feed it XLSX or ODS you will iterate
chunks of raw binary data.

the xls-each-cell manpage from the App::XLSUtils manpage

the xls-each-row manpage from the App::XLSUtils manpage

Converting to CSV

`CATDOC' (http://www.wagner.pp.ru/~vitus/software/catdoc/) contains following
the programs `catdoc' (to print the plain text of Microsoft Word documents to
standard output), the xls2csv manpage (to convert Microsoft Excel workbook files to
CSV), and `catppt' (to print plain text of Mirosoft PowerPoint presentations to
standard output). Available as Debian package. They only support the older
format (XLS and not XLSX). They do not support LibreOffice Calc format (ODS).

the xls2csv manpage from the App::XLSUtils manpage

Generating XLS

TBD

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/A*

%changelog
