# BEGIN SourceDeps(oneline):
BuildRequires: perl(Compress/Zlib.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.09
%define module_name Acme-DonMartin
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.09
Release: alt1
Summary: For programs that are easy to dictate over the telephone
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DL/DLAND/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Perl is a very difficult language to dictate over the phone. All
those pesky punctuation characters and gruesome glyphs make it very
laborious to speak out loud.

To compound the problem, most people can't even agree on what
something as basic as `#' should be called. Some of the names for
it (although by no means exhaustive) include:

     pound, pound sign, number sign, flash, hash, sharp,
     grid, crosshatch, octothorpe, square, pig-pen, hex,
     tictactoe, scratchmark, crunch, thud, thump, splat.

(and if you say these last few out loud, I think you can begin to
see where this is going). And if you think that's bad, wait until
you hear some of the sillier symbols, like `%%', `&' and `@'.

The first time you run a program under `Acme::DonMartin', nothing
happens, but your source code is magically transformed into Don
Martin cartoon sound effects. The code continues to work as before,
but now the above program looks something like this:

   #! /usr/local/bin/perl

   use Acme::DonMartin;
   gashlikt ahweeeeee dipada fliff gahak dapada zap thwizzik
   gahork tik gark dakdik gleet skroook skronk chomple dig
   klooonn sloople tik fling splork gleet cook chook wiz
   bombah boomer poong glong shuka spatz

The next time it is run, it will function as it did previously.

Now you can pick up the phone and dictate it to someone else
and they can type it in to a computer and run it with much
less chance of confusion or error.

This is also a security feature. It is expected that a government
official who has wire-tapped your line will be laughing too hard
to be able to recover the source code.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/A*

%changelog
