%define module_version 0.02
%define module_name Acme-HashKeyOrderBrokenAgain
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(Test/Simple.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Request reproducable hash keys order within a script and verify if Perl complies
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MS/MSCHILLI/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
We all know that Perl's keys() function will return the keys of a hash in 
unpredictable order. However, for testing purposes, we sometimes need
the keys by keys() to be returned in deterministic order, which means that
although the order can't be predicted up front, subsequent calls to
keys() within the same script should return the keys in the same order if
(and only if)

    $ENV{ PERL_PERTURB_KEYS } = "DETERMINISTIC"

is set. 

This module checks if the feature actually works, and will hopefully alert 
Perl Porters via automatic CPAN smoke tests if it's broken. If the above 
assumption is incorrect, please drop me a message, I'll adapt this module
accordingly.

See 

    http://perlmonks.org/?node_id=1056280

and

   https://github.com/mschilli/php-httpbuildquery-perl/pull/3

for details on this issue.


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/A*

%changelog
