%define module_name Acme-InputRecordSeparatorIsRegexp
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/Handle.pm) perl(Symbol.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.07
Release: alt1
Summary: Actually, awk doesn't have to be 
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MO/MOB/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
In the section about the "input record separator",
`perlvar' famously notes

=over 4

Remember: the value of $/ is a string, not a regex. awk
has to be better for something. :-)

=back

This module provides a mechanism to read records from a file
using a regular expression as a record separator.

A common use case for this module is to read a text file 
that you don't know whether it uses Unix (`\n'), 
Windows/DOS (`\r\n'), or Mac (`\r') style line-endings, 
or even if it might contain all three. To properly parse
this file, you could tie its filehandle to this package with
the appropriate regular expression:

    my $fh = Symbol::gensym;
    tie *$fh, 'Acme::InputRecordSeparatorIsRegexp', '\r\n|\r|\n';
    open $fh, '<', 'file-with-ambiguous-line-endings';

    @lines = <$fh>;
    # or
    while (my $line = <$fh>) { ... }

The lines produced by the `<$fh>' expression, like the
builtin `readline' function and operator, include the record
separator at the end of the line, so the lines returned may end
in `\r\n', `\r', or `\n'.

Other use cases are files that contain multiple types of records
where a different sequence of characters is used to denote the
end of different types of records.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/A*

%changelog
