# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Keyword/Simple.pm) perl(PadWalker.pm) perl(Test/Fatal.pm) perl(Text/Balanced.pm)
# END SourceDeps(oneline)
%define module_name Acme-Lexical-Thief
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: steal lexical variables from your caller
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Acme-Lexical-Thief

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TO/TOBYINK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This package allows you access to your caller's lexical variables, without
them knowing! Full read/write access. This is generally a pretty bad idea,
hence the Acme namespace.

You can steal scalars, arrays and hashes:

   steal $car, @treasures, %%stash;

Parentheses can surround the list of variables to steal:

   steal ($car, @treasures, %%stash);

Generally everything should "just work" as you expect it to. Except when it
does not.

Technically speaking, your stolen `$car' is a package-scoped (`our')
variable which is lexically aliased (`local *car') to the caller's
variable of the same name. Because `steal' is parsed at compile-time,
you don't need to (and indeed should not!) pre-declare your stolen
variables.

   sub greet_verbally {
      my $name;   # don't do this!
      steal $name;
      say "Hello $name";
   }

By default, this module steals from your *immediate* caller. You can
thieve higher up the call stack using:

   steal 0 ($car);  # caller's $car
   steal 1 @boats;  # caller's caller's @boats
   steal 2 %%stash;  # caller's caller's caller's @stash

You cannot indicate the level you wish to steal from using a variable; it
must be a literal integer in your source code. (It can be in decimal, octal,
hexadecimal or binary notation.) The integer must immediately follow the
`steal' keyword, and not be followed by a comma.

The `steal' keyword cannot be used in an expression; it must be a
standalone statement.

   steal $foo;
   if (defined $foo) { ... } # ok
   
   if (steal $foo) { ... }   # not this!
   
   # this works...
   if (do { steal $foo; defined $foo })
   {
      # ... but $foo won't exist in this block!
      ...
   }

If you attempt to steal a variable which does not exist, then a run-time
exception will be thrown.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc COPYRIGHT CONTRIBUTING Changes README LICENSE CREDITS
%perl_vendor_privlib/A*

%changelog
