%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(B.pm) perl(B/Debug.pm) perl(CPAN.pm) perl(Data/Dumper.pm) perl(Devel/Peek.pm) perl(Exporter.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Find.pm) perl(FindBin.pm) perl(JSON.pm) perl(Module/Build.pm) perl(Mouse.pm) perl(O.pm) perl(Parse/CPAN/Meta.pm) perl(Scalar/Util.pm) perl(Term/ANSIColor.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(base.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.006
%define module_name Acme-Perl-VM
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.006
Release: alt1
Summary: A Perl5 Virtual Machine in Pure Perl (APVM)
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/G/GF/GFUJI/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
`Acme::Perl::VM' is an implementation of Perl5 virtual machine in pure Perl.

Perl provides a feature to access compiled syntax trees (opcodes) by
`B' module. `B::*' modules walk into opcodes and do various things;
`B::Deparse' retrieves Perl source code from subroutine references,
`B::Concise' reports formatted syntax trees, and so on.

This module also walks into the opcodes, and executes them with its
own ppcodes.

You can run any Perl code:

    use Acme::Perl::VM;

    run_block {
        print "Hello, APVM world!\n";
    };

This code says Hello, APVM world to `stdout' as you expect.

Here is a more interesting example:

    BEGIN{ $ENV{APVM} = 'trace' }
    use Acme::Perl::VM;

    run_block {
        print "Hello, APVM world!\n";
    };

And you'll get a list of opcodes as the code runs:

    .entersub(&__ANON__) VOID
    .nextstate(main -:4) VOID
    .pushmark SCALAR
    .const("Hello, APVM world!\n") SCALAR
    .print SCALAR KIDS
    Hello, APVM world!
    .leavesub KIDS

The first `entersub' is the start of the block. The next `nextstate'
indicates the statement that says hello. `pushmark', `const', and
`print' are opcodes which runs on the statement. The last `leavesub' is
the end of the block. This is a future of the module.

In short, the module has no purpose :)


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes example
%perl_vendor_privlib/A*

%changelog
