%define module_version 0.002
%define module_name Acme-RunDoc
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(IO/File.pm) perl(Module/Runtime.pm) perl(Test/More.pm) perl(Text/Extract/Word.pm) perl(autodie.pm) swig
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: executes a Microsoft Word document as if it were Perl code
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Acme-RunDoc

Source0: http://cpan.org.ua/authors/id/T/TO/TOBYINK/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
It is recieved wisdom that word processors are better than text editors.
After all, you can style your documents with different fonts and colours;
you can take advantage of the built-in spell check; and your ugly single
and double quote characters get auto-replaced with "smart" curly versions.

This module allows you to run Perl documents edited in Microsoft Word
(and other word processors capable of saving in the ".doc" format) as
normal Perl code. You can write scripts and run them like this:

  perl -Microsoft::Word helloworld.doc

or call them from other files using:

  Acme::RunDoc->do("helloworld.doc");

You can write Perl modules using Microsoft Word too. (Just take care to
rename ".doc" to ".docm".) To "require" them:

  Acme::RunDoc->require_file("Hello/World.docm");
  Acme::RunDoc->require("Hello::World");

Acme::RunDoc searches `@INC' just like you'd expect.

You can even "use" modules written in Microsoft Word:

  BEGIN {
    require Acme::RunDoc;
    Acme::RunDoc->use("Hello::World", "greet");
  }

There's a handy shortcut for that too:

  use Acme::RunDoc "Hello::World" => ["greet"];


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc COPYRIGHT LICENSE README Changes
%perl_vendor_privlib/A*
%perl_vendor_privlib/i*

%changelog
