%define module_name Algorithm-BitVector
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(List/Util.pm) perl(Math/BigInt.pm) perl(Math/Random.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.26
Release: alt1
Summary: A Perl module for constructing memory efficient packed representations of bit vectors from differen...
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AV/AVIKAK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
My main motivation for creating this module was to provide the students at Purdue and
elsewhere with a Perl class whose API is the same as that of my Python based
`BitVector' module that appears to have become popular for prototyping algorithms
for cryptography and hash functions.

This module stores the bits of a bitvector in 16-bit unsigned shorts.  As you can see
in the constructor code for `new()', after resolving the arguments with which the
constructor is called, the very first thing the constructor does is to figure out how
many of those 2-byte shorts it needs for the bits. That does not imply that the size
of a bit array that is stored in a bitvector must be a multiple of 16.  A bitvector
can be of any size whatsoever. The `Algorithm::BitVector' class keeps track of the
number of bits through its `size' instance variable.

Note that, except for one case, the constructor must be called with a single keyword
argument, which determines how the bitvector will be constructed.  The single
exception to this rule is for the keyword argument `intVal' which you would normally
use for constructing a bitvector from an integer.  The additional option you can
supply with `intVal' is `size'.  When both `intVal' and `size' are specified in a
constructor call, you get a bitvector of the specified size provided the value
supplied for `size' is larger than what it takes to accommodate the bits for the
`intVal' integer.

In addition to constructing bitvectors from integers, this module can also construct
bitvectors from bit strings, from ASCII text strings, from hex strings, from a list
of bits, and from the contents of a file.  With regards to constructing bitvectors
from integers, the module can construct very large bitvectors from very large
integers stored as `Math::BigInt' objects.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Examples
%perl_vendor_privlib/A*

%changelog
