# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Algorithm-ChooseSubsets
%define upstream_version 0.02

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_11

Summary:    OO interface to iterate through subsets of a list
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Algorithm/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildArch: noarch
Source44: import.info

%description
    "Subsets" in this context refers to lists with elements taken
from the original list, and in the same order as the elements in the
original list.  After creating the object, subsequent calls to next()
will return the next such list in lexicographic order (where the alphabet
is the original list).

    If K is specified, only subsets of that size will be returned.  If K
is omitted, all subsets will be returned, beginning with the empty set
and ending with the entire set.  If the 'all' flag and a value for 'K' are
specified, subsets of size greater than or equal to K will be returned.

    If a number, N, is used instead of a list, the list is taken to
be [0..N-1].

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes README TODO
%perl_vendor_privlib/*




%changelog
