# BEGIN SourceDeps(oneline):
BuildRequires: perl(DBD/SQLite.pm) perl(DBI.pm) perl(ExtUtils/MakeMaker.pm) perl(Graph/Directed.pm) perl(Graph/Feather.pm) perl(JSON.pm) perl(List/MoreUtils.pm) perl(List/Util.pm) perl(List/UtilsBy.pm) perl(Log/Any.pm) perl(Memoize.pm) perl(Moo.pm) perl(Test/More.pm) perl(Types/Standard.pm) perl(YAML/XS.pm)
# END SourceDeps(oneline)
%define module_name Algorithm-ConstructDFA2
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: Deterministic finite automaton construction
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BJ/BJOERN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module computes deterministic finite automata from equivalent
non-deterministic finite automata. The input NFA must be expressed
as directed graph with labeled vertices. Vertex labels indicate if
vertices match a particular terminal symbol from an input alphabet,
or match the empty string, meaning they can be crossed without any
input when matching a string.

This is slightly different from how NFA graphs are usually encoded
in literature (as graph with labeled edges), but the conversion is
straightforward (turn edges into additional vertices). Finding a
suitable alphabet is more difficult, the Set::IntSpan::Partition manpage can
help with that (the module splits sets of sets of terminals like
"letters" and "digits" and "hexdigits" into non-overlapping sets,
each of which can then be used as a terminal for this module).

DFAs can be exponentially larger than equivalent NFAs; to accomodate
large or complicated NFAs, computed data is held in a SQLite database
to reduce memory use. Since a DFA is basically just the result of
exhaustively computing cross-products, most computation is done in
SQL, leaving only minimal Perl code.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/A*

%changelog
