# BEGIN SourceDeps(oneline):
BuildRequires: perl(Algorithm/RectanglesContainingDot.pm) perl(B/Deparse.pm) perl(Bit/Vector.pm) perl(Clone.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(GD.pm) perl(GD/Image.pm) perl(List/Util.pm) perl(Math/Random.pm) perl(Memoize.pm) perl(Object/Array.pm) perl(Pod/Escapes.pm) perl(Sort/Key.pm) perl(Statistics/Basic.pm) perl(String/Random.pm) perl(Test.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Time/HiRes.pm) perl(Tk.pm) perl(Tree/DAG_Node.pm) perl(XML/Parser.pm) perl(XML/Parser/Style/EasyTree.pm) perl(YAML.pm) perl(base.pm) perl(constant.pm) perl(version.pm)
# END SourceDeps(oneline)
%define module_version 0.80
%define module_name Algorithm-Evolutionary
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.80
Release: alt2
Summary: Perl module for performing paradigm-free evolutionary algorithms. 
Group: Development/Perl
License: open_source
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/J/JM/JMERELO/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
`Algorithm::Evolutionary' is a set of classes for doing object-oriented
evolutionary computation in Perl. Why would anyone want to do that
escapes my knowledge, but, in fact, we have found it quite useful for
our own purposes. Same as Perl itself.

The main design principle of the Algorithm::Evolutionary manpage is *flexibility*: it
should be very easy to create your own evolutionary algorithms using this library, and it should be
also quite easy to program what's already there in the evolutionary
computation community. Besides, the library classes should have
persistence provided by YAML.

The module allows to create simple evolutionary algorithms, as well
as more complex ones, that interface with databases or with the
web. 

=begin html

<p>The project has been, from version 0.79, moved to
<a href='http://github.com/JJ/Algorithm-Evolutionary'>GitHub</a>. Latest aditions, and
nightly updates, can be downloaded from there before they are uploaded
to CPAN. That page also hosts the mailing list, as well as bug
reports, news, updates, work in progress, lots of stuff.</p>

<p>In case the examples are hidden somewhere in the <code>.cpan</code> directory,
    you can also download them from <a
    href='https://github.com/JJ/Algorithm-Evolutionary/tree/master/examples'>the
    git repository</a>. You can also get help from the <a
href='https://github.com/JJ/Algorithm-Evolutionary/issues'>project
issues</a>.</p> 

<p>It might be also helpful for you to check out <a
href='http://arxiv.org/abs/0908.0516'>Still doing evolutionary
algorithms with Perl</a>, a gentle introduction to evolutionary
algorithms in general and working with them using this module in particular.</p>

<p>I have used this continously for my research all these year, and
any search will return a number of papers; a journal article is
already submitted, but meanwhile if you use it for any of your
research, I would be very grateful if you quoted papers such as these
(which are, of course, available under request or from your friendly
 university librarian):</p>

=end html

 @article {springerlink:10.1007/s00500-009-0504-3,
   author = {Merelo Guervaus, Juan-Julia.n and Castillo, Pedro and Alba, Enrique},
   affiliation = {Universidad de Granada Depto. Arquitectura y Tecnologada de Computadores, ETS Ingenieradas Informa.tica y Telecomunicaciones Granada Spain},
   title = {Algorithm::Evolutionary, a flexible Perl module for evolutionary computation},
   journal = {Soft Computing - A Fusion of Foundations, Methodologies and Applications},
   publisher = {Springer Berlin / Heidelberg},
   issn = {1432-7643},
   keyword = {Computer Science},
   pages = {1091-1109},
   volume = {14},
   issue = {10},
   url = {http://dx.doi.org/10.1007/s00500-009-0504-3},
   note = {10.1007/s00500-009-0504-3},
   year = {2010}
 }

or

 @InProceedings{jj:2008:PPSN,
   author =_"Juan J. Merelo and  Antonio M. Mora and Pedro A. Castillo
                 and Juan L. J. Laredo and Lourdes Araujo and Ken C. Sharman
                 and Anna I. Esparcia-Alca.zar and Eva Alfaro-Cid
                 and Carlos Cotta",
   title =_"Testing the Intermediate Disturbance Hypothesis: Effect of
                 Asynchronous Population Incorporation on Multi-Deme
                 Evolutionary Algorithms",
   booktitle =_"Parallel Problem Solving from Nature - PPSN X",
   year = _"2008",
   editor =_"Gunter Rudolph and Thomas Jansen and Simon Lucas and
__  Carlo Poloni and Nicola Beume",
   volume =_"5199",
   series =_"LNCS",
   pages =_"266-275",
   address =_"Dortmund",
   month =_"13-17 " # sep,
   publisher =_"Springer",
   keywords =_"genetic algorithms, genetic programming, p2p computing",
   ISBN = _"3-540-87699-5",
   doi =  _"10.1007/978-3-540-87700-4_27",
   size = _"pages",
   notes =_"PPSN X",
 }

=begin html

<p>or the ArXiV paper linked above.</p>

<p>Some information on this paper and instructions for downloading the code used in it can
be found in <a
href='http://nohnes.wordpress.com/2008/09/21/paper-on-performance-of-asynchronous-distributed-evolutionary-algorithms-available-online/'>our
group blog</a>.</p> 

=end html

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc Changes README LICENSE TODO.md
%perl_vendor_privlib/A*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
