%define module_name Algorithm-FEC
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(XSLoader.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.1
Release: alt8
Summary: Forward Error Correction using Vandermonde Matrices
Group: Development/Perl
License: see LICENSE
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/ML/MLEHMANN/%{module_name}-%{version}.tar.gz

%description
This module is an interface to the fec library by Luigi Rizzo et al., see
the file README.fec in the distribution for more details.

This library implements a simple (`encoded_blocks',`data_blocks')
erasure code based on Vandermonde matrices.  The encoder takes
`data_blocks' blocks of size `block_size' each, and is able to produce
up to `encoded_blocks' different encoded blocks, numbered from `0'
to `encoded_blocks-1', such that any subset of `data_blocks' members
permits reconstruction of the original data.

Allowed values for `data_blocks' and `encoded_blocks' must obey the
following equation:

   data_blocks <= encoded_blocks <= MAXBLOCKS

Where `MAXBLOCKS=256' for the fast implementation and `MAXBLOCKS=65536'
for the slow implementation (the implementation is chosen automatically).

=over 4

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.fec README Changes LICENSE
%perl_vendor_archlib/A*
%perl_vendor_autolib/*

%changelog
