%define module_name Algorithm-Graphs-TransitiveClosure-Tiny
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.03
Release: alt1
Summary: Calculate the transitive closure.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AA/AAHAZRED/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides a single function, `floyd_warshall', which is exported
on demand. It is an implementation of the well known *Floyd-Warshall*
algorithm computing the transitive closure of a graph.

The code is taken from the Algorithm::Graphs::TransitiveClosure manpage but has been
modified. The difference is that this implementation of `floyd_warshall()':

=over

=item *

works on hashes only,

=item *

uses `undef' for hash values, so an incidence must be checked with
`exists()' (but for the input hash you are not forced to use `undef'),

=item *

fixes following problem of the Algorithm::Graphs::TransitiveClosure manpage:

Example:

   my $g = {
            0 => { 2 => 1},
            1 => { 0 => 1},
           };

There is an edge from 0 to 2 and an edge from 1 to 0. So the transitive
closure would contain an edge from 1 to 2. But calling `floyd_warshall($g)'
from the Algorithm::Graphs::TransitiveClosure manpage results in:

           {
            0 => { 2 => 1},
            1 => { 0 => 1},
           }

No change. The edge from 1 to 2 is missing (you would need to add `2=>{}'
to `$g' to get it right). But if you call `floyd_warshall($g)' from
`Algorithm::Graphs::TransitiveClosure::Tiny', then the result is correct:

           {
            0 => { 2 => 1},
            1 => { 0 => 1,
                   2 => undef},
           }

Edge from 1 to 2 has been added! (Also note that you could use 1 instead of
`undef' as hash value, but the value added by the function is `undef'
anyway!)


=item *

By default, `floyd_warshall($graph)' removes empty subhashes from `$graph',
e.g.

    my $graph = {
                 this => {that => undef},
                 that => {}
                };
    floyd_warshall($graph);

will result in

   {
    this => {that => undef}
   }

This behavior can be changed by setting optional second argument of
`floyd_warshall' to a true value, i.e., calling `floyd_warshall($graph, 1)'
with the above example h...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/A*

%changelog
