%define module_name Algorithm-LUHN_XS
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Test.pm) perl(XSLoader.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.08
Release: alt4
Summary: Very Fast XS Version of the original Algorithm::LUHN
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/K/KS/KSCHWAB/%{module_name}-%{version}.tar.gz

%description
This module is an XS version of the original Perl Module Algorithm::LUHN, which
was written by Tim Ayers.  It should work exactly the same, only substantially
 faster. The supplied check_digit() routine is 100%% compatible with the pure
Perl Algorithm::LUHN module, while the faster check_digit_fast and really fast
check_digit_rff are not. 

How much faster? Here's a benchmark, running on a 3.4GHz i7-2600:

`Benchmark: timing 100 iterations'

`Algorithm::LUHN: 69 secs (69.37 usr 0.00 sys)  1.44/s'

`check_digit:      2 secs ( 1.98 usr 0.00 sys) 50.51/s'

`check_digit_fast: 2 secs ( 1.68 usr 0.00 sys) 59.52/s'

`check_digit_rff:  1 secs ( 1.29 usr 0.00 sys) 77.52/s'

So, it's 35x to 53x faster than the original pure Perl module, depending on
how much compatibility with the original module you need.

The rest of the documentation is mostly a copy of the original docs, with some
additions for functions that are new.

This module calculates the Modulus 10 Double Add Double checksum, also known as
the LUHN Formula. This algorithm is used to verify credit card numbers and
Standard & Poor's security identifiers such as CUSIP's and CSIN's.

You can find plenty of information about the algorithm by searching the web for
"modulus 10 double add double".

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE README.md
%perl_vendor_archlib/A*
%perl_vendor_autolib/*

%changelog
