%define module_name Algorithm-NCS
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Inline.pm) perl(Inline/C.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt4
Summary: Fast Perl extension for sequence alignment.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/V/VL/VLD/%{module_name}-%{version}.tar.gz

%description
Number of Common Substrings (NCS) - A model and algorithm 
for sequence alignment.
The change detection problem is aimed at identifying common and
different strings and usually has non-unique solutions.  The identification of the
best alignment is canonically based on finding a
longest common subsequence
(LCS) and is widely used for various purposes.  However, many recent version
control systems prefer alternative heuristic algorithms which not only are faster
but also usually produce better alignment than finding an
LCS.
http://psta.psiras.ru/read/psta2015_1_189-197.pdf
http://elib.sfu-kras.ru/bitstream/handle/2311/19864/Znamenskij.pdf?sequence=1
http://dl.acm.org/citation.cfm?id=2977230
%prep
%setup -q -n %{module_name}-%{version}
# depth is > 1 .. moving up
pushd "Algorithm-NCS"
  mv -f * ../
  mv -f .* ../ ||:
popd

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_autolib/*
%perl_vendor_privlib/A*

%changelog
