%define module_name Algorithm-Odometer-Tiny
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Capture/Tiny.pm) perl(Carp.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Glob.pm) perl(File/Spec/Functions.pm) perl(FindBin.pm) perl(List/Util.pm) perl(Test/DistManifest.pm) perl(Test/MinimumVersion.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(constant.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Generate "base-N odometer" permutations
Group: Development/Perl
License: perl
URL: https://github.com/haukex/Algorithm-Odometer-Tiny

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/H/HA/HAUKEX/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This class implements the permutation algorithm described in *[1]*
as an iterator. An "odometer" has a number of "wheels", each of which
can have a different number of positions. On each step, the rightmost
wheel is advanced to the next position, and if it wraps around, the
next higher wheel is incremented by one, and so on - it is the same
basic algorithm that we use to count from 0 to 100 and onwards,
except with different "digits".

The constructor of this class takes a list of array references, each
of which represents a wheel in the odometer. The constructor returns
an object of this class, which can be called as a code reference
(`$odometer->()'), or the `<>' I/O operator can be used to
read the next item. Calling the code reference or `<>' operator
in scalar context returns the current state of the wheels joined
together as a string, while calling the code reference in list
context returns the current state of the wheels as a list of
individual values. In Perl 5.18 and above, calling the `<>'
operator in list context will return all of the (remaining) values in
the sequence as strings. In scalar context, the iterator will return
`undef' once, and then start the sequence from the beginning.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md LICENSE.txt
%perl_vendor_privlib/A*

%changelog
