# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Math/BigRat.pm) perl(Math/Cephes/Fraction.pm) perl(Moo.pm) perl(MooX/Types/MooseLike.pm) perl(PDL.pm) perl(PDL/Lite.pm) perl(Test/More.pm) perl(namespace/clean.pm)
# END SourceDeps(oneline)
%define module_name Algorithm-Simplex
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.44
Release: alt1
Summary: Simplex Algorithm Implementation using Tucker Tableaux
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MA/MATEU/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Base class for the Simplex model using Tucker tableaus.  

The implementation is currently limited to phase II,
i.e. one must start with a feasible solution.

This class defines some of the methods concretely, and others such as:

=over 3

=item *

pivot

=item *

is_optimal

=item *

determine_positive_ratios

=item *

determine_simplex_pivot_columns

=back

are implemented in one of the three model types:

=over 3

=item *

Float

=item *

Rational

=item *

PDL

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/A*

%changelog
