Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Alien-PCRE2
Version:        0.017000
Release:        alt1_5
Summary:        Install and locate PCRE2 library
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/Alien-PCRE2
Source0:        https://cpan.metacpan.org/authors/id/W/WB/WBRASWELL/Alien-PCRE2-%{version}.tar.gz
# Disable Alien share mode, we always use system-provided libraries,
# not suitable for the upstream.
Patch0:         Alien-PCRE2-0.017000-Disable-shared-mode.patch
# This is an architecture-dependenant package because it stores data about
# architecture-specific library, but it has no XS code, hence no debuginfo.
%global debug_package %{nil}
BuildRequires:  coreutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(Alien/Build/MM.pm)
# From ./alienfile
# Alien::Build::Plugin::Build::Autoconf not used
# From ./alienfile
# Alien::Build::Plugin::Download::GitHub 1.30 not used
# From ./alienfile
# Alien::Build::Plugin::Extract::Negotiate not used
# From ./alienfile
BuildRequires:  perl(Alien/Build/Plugin/PkgConfig/Negotiate.pm)
# From ./alienfile
BuildRequires:  perl(alienfile.pm)
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# From ./alienfile
BuildRequires:  pkgconfig(libpcre2-8)
# Run-time:
# Alien modules' purpose is to ensure one can compile against a library
BuildRequires:  libpcre2-devel
BuildRequires:  perl(Alien/Base.pm)
BuildRequires:  perl(base.pm)
# Tests:
# pcre2grep tests in t/03_pcre2grep.t skipped on system Alien installation.
BuildRequires:  perl(Capture/Tiny.pm)
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(English.pm)
BuildRequires:  perl(Env.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(IPC/Cmd.pm)
BuildRequires:  perl(Test2/V0.pm)
BuildRequires:  perl(Test/Alien.pm)
BuildRequires:  perl(Test/Alien/Diag.pm)
BuildRequires:  perl(Test/More.pm)
# Alien modules' purpose is to ensure one can compile against a library.
# We need to match an architecture,
%if "0" == "%(pkgconf --exist libpcre2-8 2>/dev/null; echo $?)"
# And we need to match a pkgconfig module version. Both compiled in.
Requires:       pkgconfig(libpcre2-8) = %(pkgconf --modversion libpcre2-8)
%endif
Requires:       perl(Alien/Base.pm) >= 0.038

# Remove underspecified dependencies

Source44: import.info
%filter_from_requires /^perl(Alien.Base.pm)/d

%description
This package can be used by other Perl modules that require PCRE2 library, the
new Perl Compatible Regular Expression engine.

%package tests
Group: Development/Perl
Summary:        Tests for %{name}
BuildArch:      noarch
Requires:       %{name} = %{?epoch:%{epoch}:}%{version}-%{release}
Requires:       coreutils

%description tests
Tests from %{name}. Execute them
with "%{_libexecdir}/%{name}/test".

%prep
%setup -q -n Alien-PCRE2-%{version}
%patch0 -p1

# Remove tests which are always skipped.
rm t/03_pcre2grep.t
perl -i -ne 'print $_ unless m{\A\Qt/03_pcre2grep.t\E}' MANIFEST
# Help generators to recognize Perl scripts
for F in t/*.t; do
    perl -i -MConfig -ple 'print $Config{startperl} if $. == 1 && !s{\A#!\s*perl}{$Config{startperl}}' "$F"
    chmod +x "$F"
done

%build
# Always use system PCRE2 no matter what version it is.
export ALIEN_PCRE2_MIN_VERSION=0
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
# %{_fixperms} %{buildroot}/*
# Remove useless alienfile which would only pull unnwanted dependencies
rm %{buildroot}/%{perl_vendor_archlib}/auto/share/dist/Alien-PCRE2/_alien/alienfile
# Install tests
mkdir -p %{buildroot}%{_libexecdir}/%{name}
cp -a t %{buildroot}%{_libexecdir}/%{name}
cat > %{buildroot}%{_libexecdir}/%{name}/test << 'EOF'
#!/bin/bash
set -e
# Test::Alien writes into CWD
DIR=$(mktemp -d)
pushd "$DIR"
cp -a %{_libexecdir}/%{name}/* ./
prove -I . -j "$(getconf _NPROCESSORS_ONLN)"
popd
rm -r "$DIR"
EOF
chmod +x %{buildroot}%{_libexecdir}/%{name}/test

%check
export HARNESS_OPTIONS=j$(perl -e 'if ($ARGV[0] =~ /.*-j([0-9][0-9]*).*/) {print $1} else {print 1}' -- '%{?_smp_mflags}')
make test

%files
%doc Changes README.md
%dir %{perl_vendor_archlib}/Alien
%{perl_vendor_archlib}/Alien/PCRE2
%{perl_vendor_archlib}/Alien/PCRE2.pm
%dir %{perl_vendor_archlib}/auto/Alien
%{perl_vendor_archlib}/auto/Alien/PCRE2
%dir %{perl_vendor_archlib}/auto/share
%dir %{perl_vendor_archlib}/auto/share/dist
%{perl_vendor_archlib}/auto/share/dist/Alien-PCRE2

%files tests
%{_libexecdir}/%{name}

%changelog
