Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Archive/Tar.pm) perl(Digest/SHA.pm) perl(IPC/Run.pm) perl(LWP/Simple.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Alien-ZMQ
Version:        0.06
Release:        alt2_25
Summary:        Find and install libzmq library
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/Alien-ZMQ
Source0:        https://cpan.metacpan.org/authors/id/C/CC/CCM/Alien-ZMQ-%{version}.tar.gz
# Tests do not need shellbang
Patch0:         Alien-ZMQ-0.06-Remove-useless-shellbang.patch
# Do not load modules unnecessary if libzmq is available
# <https://github.com/chazmcgarvey/p5-Alien-ZMQ/issues/4>
Patch1:         Alien-ZMQ-0.06-Load-less-modules-if-libzmq-is-available.patch
BuildArch:      noarch
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
# Archive::Tar 1.00 not used
BuildRequires:  perl(base.pm)
BuildRequires:  perl(Cwd.pm)
# Digest::SHA not used
BuildRequires:  perl(ExtUtils/CBuilder.pm)
BuildRequires:  perl(File/Path.pm)
BuildRequires:  perl(File/Spec/Functions.pm)
# IPC::Run not used
BuildRequires:  perl(lib.pm)
# LWP::Simple not used
BuildRequires:  perl(Module/Build.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
BuildRequires:  libzeromq-devel
# Run-time:
BuildRequires:  perl(String/ShellQuote.pm)
# Tests:
# English not used
BuildRequires:  perl(Test/More.pm)
Source44: import.info
# Pod::Coverage::TrustPod not used
# Test::Perl::Critic not used
# Test::Pod 1.41 not used
# Test::Pod::Coverage 1.08 not used

%description
Upon installation, the target system is guaranteed for the present of libzmq.
In short, Perl modules that need libzmq can depend on Alien::ZMQ module to
make sure that it is available.

%prep
%setup -q -n Alien-ZMQ-%{version}
%patch0 -p1
%patch1 -p1

%build
perl Build.PL installdirs=vendor
./Build

%install
./Build install destdir=$RPM_BUILD_ROOT create_packlist=0
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
unset RELEASE_TESTING
./Build test

%files
%doc --no-dereference LICENSE
%doc Changes examples README
%{perl_vendor_privlib}/*

%changelog
