%define module_name Amazon-CloudFront-Thin
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Digest/SHA.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Date.pm) perl(HTTP/Message.pm) perl(LWP/Protocol/https.pm) perl(LWP/UserAgent.pm) perl(Test/More.pm) perl(URI.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt1
Summary: A thin, lightweight, low-level Amazon CloudFront client
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GA/GARU/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Amazon::CloudFront::Thin is a thin, lightweight, low level client for Amazon CloudFront.

It is designed for only ONE purpose: send a request and get a response.

It offers the following features:

=over 4

=item Low Level

Every request returns an the HTTP::Response manpage object so you can easily inspect
what's happening inside, and can handle errors as you like.

=item Low Dependency

It has very few dependencies, so installation is easy and bloat-free
for your application. Aside from core modules like Digest::SHA, we
only rely on basic web modules like URI and HTTP::Message, which
you're probably already loaded from within your preferred web framework
or application.

=item Low Learning Cost

The interface is designed to follow Amazon CloudFront's official REST APIs.
So it is easy to learn and use by following the official documentation.

=back
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes
%perl_vendor_privlib/A*

%changelog
