%define module_name Amazon-S3-Thin
# BEGIN SourceDeps(oneline):
BuildRequires: perl(AWS/Signature4.pm) perl(Config/Tiny.pm) perl(Digest/HMAC_SHA1.pm) perl(Digest/MD5.pm) perl(Digest/SHA.pm) perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(Encode/TW.pm) perl(HTTP/Date.pm) perl(HTTP/Headers.pm) perl(HTTP/Request.pm) perl(HTTP/Response.pm) perl(JSON/PP.pm) perl(LWP/UserAgent.pm) perl(MIME/Base64.pm) perl(Module/Build/Tiny.pm) perl(Test/More.pm) perl(URI/Escape.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.32
Release: alt1
Summary: A thin, ligthweight, low-level Amazon S3 client
Group: Development/Perl
License: perl
URL: https://github.com/DQNEO/Amazon-S3-Thin

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AK/AKIYM/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Amazon::S3::Thin - A thin, ligthweight, low-level Amazon S3 client.

=over

=item Low Level

It returns HTTP::Response. So you can inspect easily what's happening inside , and can handle error as you like.


=item Low Dependency

It does require no XML::* modules, so that installation be easy;

=item Low Learning Cost

The interfaces are designed to follow S3 official REST APIs. So it is easy to learn.

=back


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md LICENSE Changes
%perl_vendor_privlib/A*

%changelog
