%define module_name Amazon-SNS-V4
# BEGIN SourceDeps(oneline):
BuildRequires: perl(AWS/Signature4.pm) perl(Class/Accessor.pm) perl(Class/Accessor/Fast.pm) perl(HTTP/Request/Common.pm) perl(JSON.pm) perl(LWP/UserAgent.pm) perl(Module/Build/Tiny.pm) perl(URI/Escape.pm) perl(XML/Simple.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.0
Release: alt1
Summary: Amazon Simple Notification Service, V4 Signatures
Group: Development/Perl
License: gpl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JW/JWRIGHT/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use Amazon::SNS::V4;

  my $sns = Amazon::SNS::V4->new({ 'key' => '...', 'secret' => '...' });


  # create a new topic and publish

  my $topic = $sns->CreateTopic('MyTopic')
_or die $sns->error;

  $topic->Publish('My test message');


  # delete it!

  $topic->DeleteTopic;


  # publish to a known ARN

  my $topic = $sns->GetTopic('arn:aws:sns:eu-west-1:123456789099:MyTopic');

  $topic->Publish('My test message', 'My Subject');


  # get all topics

  my @topics = $sns->ListTopics;

  print $_->arn, "\n" for @topics;



  # change region

  $sns->service('http://sns.us-east-1.amazonaws.com');

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README AUTHORS Changes LICENSE
%perl_vendor_privlib/A*

%changelog
