%define module_name Android-Build
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Data/Dump.pm) perl(Data/Table/Text.pm) perl(File/Copy.pm) perl(Module/Build.pm) perl(POSIX.pm) perl(Test/More.pm) perl(Test2/API.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 20201115
Release: alt1
Summary: Lint, run, install an Android App
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PR/PRBRENAN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This file which can be found in the tar.gz file containing this module:

  SampleApp/perl/makeWithperl.pl

contains:

 use Android::Build;

 my $a = &Android::Build::new();

 $a->title        = qq(Generic App);                                            # Title of the app as seen under the icon
 $a->domain       = qq(com.appaapps);                                           # Domain name in reverse order
 $a->activity     = qq(Activity);                                               # Name of Activity = $activity.java file containing onCreate() for this app
 $a->icon         = qq(~/images/Jets/EEL.jpg);                                  # Image that will be scaled to make an icon using Imagemagick
 $a->sdk          = qq(~/Android/sdk/);                                         # Android SDK on the local machine
 $a->sdkLevels    = [15,25];                                                    # Min sdk, target sdk for manifest
 $a->androidJar   = $a->sdk."platforms/android-25/android.jar";                 # Android sdk jar
 $a->keyStoreFile = qq(~/keystore/release-key.keystore);                        # Keystore file
 $a->keyStorePwd  = qq(xxx);                                                    # Password for keystore

 $a->build(qw(run));                                                            # Compile and run the app

Modify the values above to reflect your local environment, then start an
emulator and run:

 perl SampleApp/perl/makeWithPerl.pl

to compile the sample app and load it into the emulator.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CONTRIBUTING README README.md CHANGES
%perl_vendor_privlib/A*

%changelog
