# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    AnnoCPAN-Perldoc
%define upstream_version 0.10

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_13

Summary:    Integrate AnnoCPAN notes locally into perldoc
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/AnnoCPAN/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(DBD/SQLite.pm)
BuildRequires: perl(DBI.pm)
BuildRequires: perl(Digest/MD5.pm)
BuildRequires: perl(IO/String.pm)
BuildRequires: perl(Pod/Parser.pm)
BuildRequires: perl(Pod/Perldoc.pm)
BuildRequires: perl(Test/Pod.pm)
BuildRequires: perl-devel

BuildArch: noarch
Source44: import.info


%description
AnnoCPAN is a web interface for the documentation of all the modules on
CPAN, where users can add annotations on the margin of specific paragraphs
throughout the POD. The master AnnoCPAN site is located at
http://annocpan.org/.

AnnoCPAN-Perldoc provides a substitute for the 'perldoc' command that
displays the annotations locally and without requiring a connection to the
Internet. It works by using a local note database that can be downloaded
from

    http://annocpan.org/annopod.db

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

%check
make test

%install
%makeinstall_std

%files
%doc README META.yml
%{_mandir}/man1/*
%perl_vendor_privlib/*
/usr/bin/annopod


%changelog
